using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;

namespace MojaDrugaGra
{
    class Prostopadloscian : DrawableGameComponent
    {
        private GraphicsDevice gd;
        private BasicEffect efekt;
        private VertexBuffer buforWerteksow;

        public Prostopadloscian(Game game, BasicEffect efekt,
                                float dx, float dy, float dz, Color? kolor) : base(game)
        {
            dx /= 2;
            dy /= 2;
            dz /= 2;
            gd = game.GraphicsDevice;
            this.efekt = (BasicEffect)efekt.Clone();
            Vector3[] punkty = new Vector3[8]{
                new Vector3(-dx, -dy, dz),
                new Vector3(dx, -dy, dz),
                new Vector3(dx, dy, dz),
                new Vector3(-dx, dy, dz),
                new Vector3(-dx, -dy, -dz),
                new Vector3(dx, -dy, -dz),
                new Vector3(dx, dy, -dz),
                new Vector3(-dx, dy, -dz)
            };
            Color kolor1 = kolor ?? Color.Cyan;
            Color kolor2 = kolor ?? Color.Magenta;
            Color kolor3 = kolor ?? Color.Yellow;

            VertexPositionNormalColor[] werteksy = new VertexPositionNormalColor[24]
            {
                //przednia sciana
                new VertexPositionNormalColor(punkty[3], Vector3.UnitZ, kolor1),
                new VertexPositionNormalColor(punkty[2], Vector3.UnitZ, kolor1),
                new VertexPositionNormalColor(punkty[0], Vector3.UnitZ, kolor1),
                new VertexPositionNormalColor(punkty[1], Vector3.UnitZ, kolor1),
                //tylnia sciana
                new VertexPositionNormalColor(punkty[7], -Vector3.UnitZ, kolor1),
                new VertexPositionNormalColor(punkty[4], -Vector3.UnitZ, kolor1),
                new VertexPositionNormalColor(punkty[6], -Vector3.UnitZ, kolor1),
                new VertexPositionNormalColor(punkty[5], -Vector3.UnitZ, kolor1),
                //gorna sciana
                new VertexPositionNormalColor(punkty[3], Vector3.UnitY, kolor2),
                new VertexPositionNormalColor(punkty[7], Vector3.UnitY, kolor2),
                new VertexPositionNormalColor(punkty[2], Vector3.UnitY, kolor2),
                new VertexPositionNormalColor(punkty[6], Vector3.UnitY, kolor2),
                //dolna sciana
                new VertexPositionNormalColor(punkty[0], -Vector3.UnitY, kolor2),
                new VertexPositionNormalColor(punkty[1], -Vector3.UnitY, kolor2),
                new VertexPositionNormalColor(punkty[4], -Vector3.UnitY, kolor2),
                new VertexPositionNormalColor(punkty[5], -Vector3.UnitY, kolor2),
                //lewa sciana
                new VertexPositionNormalColor(punkty[3], -Vector3.UnitX, kolor3),
                new VertexPositionNormalColor(punkty[0], -Vector3.UnitX, kolor3),
                new VertexPositionNormalColor(punkty[7], -Vector3.UnitX, kolor3),
                new VertexPositionNormalColor(punkty[4], -Vector3.UnitX, kolor3),
                //prawa sciana
                new VertexPositionNormalColor(punkty[1], Vector3.UnitX, kolor3),
                new VertexPositionNormalColor(punkty[2], Vector3.UnitX, kolor3),
                new VertexPositionNormalColor(punkty[5], Vector3.UnitX, kolor3),
                new VertexPositionNormalColor(punkty[6], Vector3.UnitX, kolor3)
            };            

            buforWerteksow = new VertexBuffer(
                gd, 
                VertexPositionNormalColor.VertexDeclaration,
                werteksy.Length, 
                BufferUsage.WriteOnly); 

            buforWerteksow.SetData<VertexPositionNormalColor>(werteksy);
        }

        public override void Draw(GameTime gameTime)
        {
            gd.SetVertexBuffer(buforWerteksow);
            foreach (EffectPass pass in efekt.CurrentTechnique.Passes)
            {
                pass.Apply();
                for (int i = 0; i < 6; ++i)
                    gd.DrawPrimitives(PrimitiveType.TriangleStrip, 4 * i, 2);
            }
            base.Draw(gameTime);
        }

        public Matrix MacierzSwiata
        {
            get => efekt.World;
            set => efekt.World = value;
        }

        public Matrix MacierzWidoku
        {
            get => efekt.View;
            set => efekt.View = value;            
        }
    }
}
